function [theta_n, theta_f] = find_th_n_fracking(F_o, theta_o ,beta, epsilon, alpha, xi, ...
                eta, psi, lambda, nu, varphi, gamma, delta, s_o, G_o, G_n, G_f, psi_f, eta_f, lambda_f)
% This function computes the equilibrium level of theta_n given F_O and theta_o

theta_n = fzero(@(th) resid_th_n_f(exp(th), F_o, theta_o, beta, epsilon, alpha, xi, eta, ...
                             psi, lambda, nu, varphi, gamma, delta, s_o, G_o, G_n, G_f, psi_f, eta_f, lambda_f),...
                             log(0.03));

[~, theta_f] = resid_th_n_f(exp(theta_n), F_o, theta_o, beta, epsilon, alpha, xi, eta, ...
                             psi, lambda, nu, varphi, gamma, delta, s_o, G_o, G_n, G_f, psi_f, eta_f, lambda_f);                         

theta_f = log(theta_f);                         
disp(['theta_N = ' num2str(exp(theta_n)) ', theta_f = ' num2str(exp(theta_f))])


end

function [resid, theta_f] = resid_th_n_f(theta_n, F_o, theta_o,beta, epsilon, alpha, xi, eta, ...
                             psi, lambda, nu, varphi,  gamma, delta, s_o, G_o, G_n, ...
                             G_f, psi_f, eta_f, lambda_f)
                         
r       = 1/beta - (1-delta);
X_o     = 1/lambda * F_o * theta_o;
I_o     = (lambda*X_o*G_o^(xi-1))^(1/xi);

mu_1    = beta/(1-beta)*(eta-1)*psi*theta_n^(eta);
P       = mu_1 + eta*psi*theta_n^(eta-1);
mu_2    = lambda/(1-beta*(1-lambda)) * mu_1;
I_n     = (xi * G_n^(1-xi) * mu_2)^(1/(1-xi));
X_n     = 1/lambda * I_n^(xi) * G_n^(1-xi);
F_n     = 1/theta_n * lambda * X_n;

% Fracking: obtaining psi_f.
theta_f = theta_n; % Initial guess
f_th    = @(tht) psi_f - (1-beta)*P *((1-beta*(1-tht))*eta_f*tht^(eta_f-1)-beta*tht^(eta_f))^(-1);
evalc('[theta_f] = fsolve(f_th, theta_f);');


mu_1_f   = beta/(1-beta)*(eta_f-1)*psi_f*theta_f^(eta_f);
mu_2_f   = lambda_f/(1-beta*(1-lambda_f)) * mu_1_f;
I_f      = (xi * G_f^(1-xi) * mu_2_f)^(1/(1-xi));
X_f      = 1/lambda_f * I_f^(xi) * G_f^(1-xi);
F_f      = 1/theta_f * lambda_f * X_f;

O       = theta_n * F_n + theta_f * F_f + theta_o * F_o;
Y       = s_o^(-epsilon)*P^(epsilon)*O;
VA      = (1/(1-s_o)*(Y^((epsilon-1)/epsilon)-s_o*O^((epsilon-1)/epsilon)))^(epsilon/(epsilon-1));
L       = (r/varphi * (1-alpha)/alpha * VA^(1/alpha))^(1/(nu+1/alpha));
K       = VA^(1/alpha)*L^(1-1/alpha);
C       = Y - delta*K -I_n - I_o -I_f - psi*theta_n^(eta)*F_n - psi_f*theta_f^(eta_f)*F_f - psi*theta_o^(eta)*F_o;

resid   = r - alpha*(1-s_o)*Y^(1/epsilon)...
            *K^((epsilon-1)/epsilon*alpha - 1)...
            *L^((epsilon-1)/epsilon*(1-alpha));
end

                